/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.block;

import com.nyfaria.numismaticoverhaul.block.ShopBlockEntity;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.item.MoneyBagItem;
import com.nyfaria.numismaticoverhaul.villagers.data.NumismaticTradeOfferExtensions;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;

public class ShopOffer {
    private final ItemStack sell;
    private final long price;

    public ShopOffer(ItemStack sell, long price) {
        if (sell.m_41619_()) {
            throw new IllegalArgumentException("Sell Stack must not be empty");
        }
        if (price == 0L) {
            throw new IllegalArgumentException("Price must not be null");
        }
        this.sell = sell;
        this.price = price;
    }

    public MerchantOffer toTradeOffer(ShopBlockEntity shop, boolean inexhaustible) {
        ItemStack buy = CurrencyConverter.getRequiredCurrencyTypes(this.price) == 1 ? CurrencyConverter.getAsItemStackList(this.price).get(0) : MoneyBagItem.create(this.price);
        int maxUses = inexhaustible ? Integer.MAX_VALUE : ShopOffer.count(shop.getItems(), this.sell) / this.sell.m_41613_();
        MerchantOffer tradeOffer = new MerchantOffer(buy, this.sell, maxUses, 0, 0.0f);
        ((NumismaticTradeOfferExtensions)tradeOffer).numismatic$setReputation(-69420);
        return tradeOffer;
    }

    public long getPrice() {
        return this.price;
    }

    public ItemStack getSellStack() {
        return this.sell.m_41777_();
    }

    public static CompoundTag writeAll(CompoundTag tag, List<ShopOffer> offers) {
        ListTag offerList = new ListTag();
        for (ShopOffer offer : offers) {
            offerList.add((Object)offer.toNbt());
        }
        tag.m_128365_("Offers", (Tag)offerList);
        return tag;
    }

    public static void readAll(CompoundTag tag, List<ShopOffer> offers) {
        offers.clear();
        ListTag offerList = tag.m_128437_("Offers", 10);
        for (Tag offerTag : offerList) {
            offers.add(ShopOffer.fromNbt((CompoundTag)offerTag));
        }
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("Price", this.price);
        CompoundTag itemNbt = new CompoundTag();
        this.sell.m_41739_(itemNbt);
        nbt.m_128365_("Item", (Tag)itemNbt);
        return nbt;
    }

    public static ShopOffer fromNbt(CompoundTag nbt) {
        ItemStack item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        return new ShopOffer(item, nbt.m_128454_("Price"));
    }

    public static int count(NonNullList<ItemStack> stacks, ItemStack testStack) {
        int count = 0;
        for (ItemStack stack : stacks) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)testStack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static int remove(NonNullList<ItemStack> stacks, ItemStack removeStack) {
        int toRemove = removeStack.m_41613_();
        for (ItemStack stack : stacks) {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)removeStack)) continue;
            int removed = stack.m_41613_();
            stack.m_41774_(toRemove);
            if ((toRemove -= removed) >= 1) continue;
            break;
        }
        return removeStack.m_41613_() - toRemove;
    }

    public String toString() {
        return this.sell + "@" + this.price + "coins";
    }
}

